%This test is a test from the ISMP-HOM Intercomparison project
%TestF 
printingflag=false;

for i=1:4,
	L=100000; %in m
	nx=30; %numberof nodes in x direction
	ny=30;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	%md=mesh(md,'../Exp/SquareISMIP.exp',5500);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPF.par');
	md=extrude(md,4,1);

	if (i==1 | i==2),
		md=setelementstype(md,'pattyn','all');
	else
		md=setelementstype(md,'stokes','all');
	end

	md.spcvelocity(:,:)=0;
	if (i==1 | i==3),
		%Create dirichlet on the bed if no slip
		pos=find(md.gridonbed);
		md.spcvelocity(pos,1:3)=1;
	else
		pos=find(md.gridonbed & (md.x==0 | md.x==max(md.x)) & (md.y==0 | md.y==max(md.y)));
		md.spcvelocity(pos,1:3)=1;
		md.spcvelocity(pos,4)=100; %because we need a dirichlet somewhere

	end
	pos=find(~md.gridonbed);
	md.spctemperature(pos,2)=255;
	md.spctemperature(pos,1)=1;

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0);
	posx2=find(md.x==max(md.x));

	posy=find(md.y==0);
	posy2=find(md.y==max(md.y));

	md.penalties=[posx,posx2;posy,posy2];

	md.dt=3;
	md.ndt=300;
	md.output_frequency=50;
	md.prognostic_DG=0;
	md.max_nonlinear_iterations=1;

	%Compute the diagnostic
	md=SetParallel(md,8);
	md.verbose=verbose('convergence',true,'solution',true);
	md=solve(md,Transient3DSolutionEnum);

	%save the results
	results{i}=md.results.Transient3DSolution(end);
	
	%Now plot vx and delta surface 
	if (i==1 | i==3),
		plotmodel(md,'data',PatchToVec(md.results.Transient3DSolution(end).Vx),'layer',md.numlayers,'sectionvalue','../Exp/ISMIP100000.exp','title','','xlabel','','ylabel','Velocity (m/yr)','linewidth',3,'grid','on','unit','km','ylim',[91 100])
	elseif (i==2 | i==4),
		plotmodel(md,'data',PatchToVec(md.results.Transient3DSolution(end).Vx),'layer',md.numlayers,'sectionvalue','../Exp/ISMIP100000.exp','title','','xlabel','','ylabel','Velocity (m/yr)','linewidth',3,'grid','on','unit','km','ylim',[185 200])
	end
	if printingflag, 
		set(gcf,'Color','w')
		if i==1,
			printmodel('ismipfpattynvxfrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfpattynvxfrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==2,
			printmodel('ismipfpattynvxsliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfpattynvxsliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==3,
			printmodel('ismipfstokesvxfrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfstokesvxfrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==4,
			printmodel('ismipfstokesvxsliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfstokesvxsliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		end
	end

	plotmodel(md,'data',PatchToVec(md.results.Transient3DSolution(end).Surface)-md.surface,'layer',md.numlayers,'sectionvalue','../Exp/ISMIP100000.exp','title','','xlabel','','ylabel','Surface (m)','linewidth',3,'grid','on','unit','km','ylim',[-30 50])
	if printingflag, 
		set(gcf,'Color','w')
		if i==1,
			printmodel('ismipfpattyndeltasurfacefrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfpattyndeltasurfacefrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==2,
			printmodel('ismipfpattyndeltasurfacesliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfpattyndeltasurfacesliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==3,
			printmodel('ismipfstokesdeltasurfacefrozen','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfstokesdeltasurfacefrozen.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		elseif i==4,
			printmodel('ismipfstokesdeltasurfacesliding','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
			system(['mv ismipfstokesdeltasurfacesliding.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestF ']);
		end
	end
end

%Fields and tolerances to track changes
field_names     ={ ...
	'VxPattynFrozen','VyPattynFrozen','VzPattynFrozen','SurfacePattynFrozen',...
	'VxPattynSliding','VyPattynSliding','VzPattynSliding','SurfacePattynSliding',...
	'VxStokesFrozen','VyStokesFrozen','VzStokesFrozen','SurfaceStokesFrozen',...
	'VxStokesSliding','VyStokesSliding','VzStokesSliding','SurfaceStokesSliding'
};
field_tolerances={...
	1e-10,1e-09,1e-10,1e-10,...
	1e-10,1e-09,1e-10,1e-10,...
	1e-10,1e-09,1e-10,1e-10,...
	1e-10,1e-09,1e-10,1e-10,...
};
field_values={};
for i=1:4,
	result=results{i};
	field_values={field_values{:},...
		PatchToVec(result.Vx),...
		PatchToVec(result.Vy),...
		PatchToVec(result.Vz),...
		PatchToVec(result.Surface)-md.surface,...
		};
end
