/*! \file KML_Object.h 
 *  \brief: header file for kml_object abstract object
 */

#ifndef _KML_OBJECT_H_
#define _KML_OBJECT_H_

#define KML_OBJECT_ID_LENGTH         80

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
/*}}}*/

class KML_Object: public Object {

	public:

		char  id[KML_OBJECT_ID_LENGTH+1];

		/*KML_Object constructors, destructors {{{1*/
		KML_Object();
		~KML_Object();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		virtual void  Echo();
		virtual void  DeepEcho();
		virtual void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   Enum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

		/*virtual functions: */
		virtual void  Write(FILE* fid,char* indent)=0;
		virtual void  Read(FILE* fid,char* kstr)=0;


};
#endif  /* _KML_OBJECT_H */

