/*! \file KML_LinearRing.h 
 *  \brief: header file for kml_linearring object
 */

#ifndef _KML_LINEARRING_H_
#define _KML_LINEARRING_H_

#define KML_LINEARRING_ALTMODE_LENGTH    18

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Geometry.h"
/*}}}*/

class KML_LinearRing: public KML_Geometry {

	public:

		bool  extrude;
		bool  tessellate;
		char  altmode[KML_LINEARRING_ALTMODE_LENGTH+1];
        int   ncoord;
		double (*coords)[3];

		/*KML_LinearRing constructors, destructors {{{1*/
		KML_LinearRing();
		~KML_LinearRing();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id(){_error_("Not implemented yet.");};
		int   MyRank(){_error_("Not implemented yet.");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   MarshallSize(){_error_("Not implemented yet.");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet.");};
		int   Enum(){_error_("Not implemented yet.");};
		Object* copy(){_error_("Not implemented yet.");};
		/*}}}*/

};
#endif  /* _KML_LINEARRING_H */

