function femmodel=balancevelocities_core(femmdoel)
%BALANCEDVELOCITIES_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancevelocities_core(femmodel)

	%recover parameters common to all solutions
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,BalancevelocitiesAnalysisEnum);

	issmprintf(VerboseSolution,'   call computational core');
	femmodel=solver_linear(femmodel);
	
	if (solution_type==BalancevelocitiesSolutionEnum & ~control_analysis),
		issmprintf(VerboseSolution,'   saving results');
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,VelEnum);
	end

end %end function
