/*
 * CreateConstraintsBalancedthickness.c:
 */

#include "../../../Container/Container.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsBalancedthickness(Constraints** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int count;

	/*Output*/
	Constraints* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Do not add constraints in DG*/
	if(!iomodel->prognostic_DG){

		/*Fetch data: */
		IoModelFetchData(&iomodel->spcthickness,NULL,NULL,iomodel_handle,"spcthickness");

		/*Initialize counter*/
		count=0;

		/*Create spcs from x,y,z, as well as the spc values on those spcs: */
		for (i=0;i<iomodel->numberofvertices;i++){
			if(iomodel->my_vertices[i]){

				if ((int)iomodel->spcthickness[2*i]){

					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
									*(iomodel->spcthickness+2*i+1),BalancedthicknessAnalysisEnum));//we enforce first translation degree of freedom, for temperature
					count++;
				}
			}
		}

		/*Free data: */
		xfree((void**)&iomodel->spcthickness);
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
