%With the new version of mpich2: 1.3.0 this run crashes on larsen.
%
%test101 also crashes on larsen with the new version of mpich2
%
%These seg faults seem to be due to a conflict betweem matlab's blas/lapack 32 bits libraries and petsc's blas/lapack 64 bits libraries

md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=setelementstype(md,'macayeal','all');
md.cluster=none;

md.inputfilename=[md.name '.bin'];
md.outputfilename=[md.name '.outbin'];
md.num_control_type=0;
md.numrifts=0;
[md.petscoptions_analyses md.petscoptions_strings]=marshall(md.petscoptions);

if false,
	femmodel=NewFemModel(md,DiagnosticSolutionEnum,[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum],5);
else
	femmodel.solution_type=DiagnosticSolutionEnum;
	femmodel.analysis_counter=5; 
	femmodel.analysis_type_list=[DiagnosticHorizAnalysisEnum;DiagnosticVertAnalysisEnum;DiagnosticHutterAnalysisEnum;SurfaceSlopeAnalysisEnum;BedSlopeAnalysisEnum];
	[femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.constraints,femmodel.loads,femmodel.materials,femmodel.parameters]=ModelProcessor(md,femmodel.solution_type,femmodel.analysis_type_list);
	femmodel.m_nodesets=cell(5,1);
	femmodel.m_ys=cell(5,1);
	femmodel.results=struct([]);
	for i=1:5,
		analysis_type=femmodel.analysis_type_list(i);
		femmodel=SetCurrentConfiguration(femmodel,analysis_type);
		if i==1, femmodel.vertices=VerticesDof(femmodel.vertices, femmodel.parameters); end
		[femmodel.nodes]=SpcNodes(femmodel.nodes,femmodel.constraints,analysis_type);
		[femmodel.nodes]=NodesDof(femmodel.nodes,femmodel.parameters);
		femmodel.m_ys{i}=CreateNodalConstraints(femmodel.nodes,analysis_type);
		femmodel.m_nodesets{i}=BuildNodeSets(femmodel.nodes,analysis_type);
		[femmodel.elements,femmodel.loads,femmodel.nodes,femmodel.parameters] = ConfigureObjects( femmodel.elements, femmodel.loads, femmodel.nodes, femmodel.vertices,femmodel.materials,femmodel.parameters);
	end
end
femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
disp('-------------- file: crash.m line: 35'); 
ug=GetSolutionFromInputs(femmodel.elements, femmodel.nodes, femmodel.vertices, femmodel.loads, femmodel.materials, femmodel.parameters);
Test
disp('-------------- file: crash.m line: 38'); 
ug=zeros(88,1);
disp('-------------- file: crash.m line: 40'); 
uf=Reducevectorgtof( ug, femmodel.nodesets,femmodel.parameters);
Test
disp('-------------- file: crash.m line: 43'); 
uf=ug;
disp('-------------- file: crash.m line: 45'); 
[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ug);
disp('-------------- file: crash.m line: 47'); 
Test
