/*\file StringToEnum.c
 *\brief:convert enum (int) to string
 */

#include "./StringToEnum.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	char    *name    = NULL;
	int      enum_out;

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&StringToEnumUsage);

	/*Fetch inputs: */
	FetchData(&name,NAME);

	/*Run core function: */
	enum_out=StringToEnumx(name);

	/* output: */
	WriteData(ENUMOUT,enum_out);
}

void StringToEnumUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: %senum = StringToEnum(string);\n",__FUNCT__);
	_printf_(true,"\n");
}
