/*\file EnumToString.c
 *\brief:convert enum (int) to string
 */

#include "./EnumToString.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	char    *name    = NULL;
	int      enum_in;

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&EnumToStringUsage);

	/*Fetch inputs: */
	FetchData(&enum_in,ENUMIN);

	/*Run core function: */
	name=EnumToStringx(enum_in);

	/* output: */
	WriteData(NAME,name);
}

void EnumToStringUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: %sstring = EnumToString(enum);\n",__FUNCT__);
	_printf_(true,"\n");
}
