/*!\file: transient_core.cpp
 * \brief: core of the transient solution 
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "transient_core"

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void transient_core(DataSet* results,FemModel* fems, ParameterInputs* inputs){

	extern int my_rank;

	/*fem models: */
	FemModel* fem_p=NULL;

	int dim=-1;
	
	
	fem_p=fems+5;

	//first recover parameters common to all solutions
	fem_p->parameters->FindParam((void*)&dim,"dim");

	//branch out 
	if(dim==2){
		transient_core_2d(results,fems,inputs);
	}
	else if(dim==3){
		transient_core_3d(results,fems,inputs);
	}
	else throw ErrorException(__FUNCT__,exprintf("%s%i%s"," dimension ",dim," not supported yet!"));

}
