/*
 * parallel.h: 
 */

#ifndef PARALLEL_H_
#define PARALLEL_H_

#include "../objects/objects.h"
#include "../io/io.h"

Vec GradJCompute(ParameterInputs* inputs,FemModel* femmodel,double* u_g_obs);

void diagnostic_core(DataSet* results,FemModel* fems, ParameterInputs* inputs);
void prognostic_core(DataSet* results,FemModel* fems, ParameterInputs* inputs);

void thermal_core(DataSet* results,FemModel* fems, ParameterInputs* inputs);
void thermal_core_nonlinear(Vec* ptg,double* pmelting_offset,FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);

void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);
void diagnostic_core_linear(Vec* ppg,FemModel* fem,ParameterInputs* inputs,int  analysis_type,int sub_analysis_type);

void transient_core(DataSet* results,FemModel* fems, ParameterInputs* inputs);
void transient_core_2d(DataSet* results,FemModel* fems, ParameterInputs* inputs);
void transient_core_3d(DataSet* results,FemModel* fems, ParameterInputs* inputs);

//int GradJOrth(WorkspaceParams* workspaceparams);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void OutputResults(DataSet* results,char* filename);
void OutputControl(Vec u_g,double* p_g,double* J,int nsteps,FemModel* fem,char* outputfilename);
void WriteLockFile(char* filename);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,char* analysis_type,char* sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);
void qmu(const char* dakota_input_file,const char* dakota_output_file,const char* dakota_error_file,FemModel* femmodels,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);
void SpawnCore(double* responses,double* variables,char** variable_descriptors,int numvariables, FemModel* femmodels,ParameterInputs* inputs,int analysis_type,int sub_analysis_type,int counter);
void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,FemModel* femmodels, DataSet* results,int analysis_type,int sub_analysis_type);
void ProcessResults(DataSet** presults,FemModel* fems,int analysis_type);

#endif
