#!/bin/bash
#Synchronize EnumToStringx.cpp and StringToEnumx.cpp and matlab Enums

#Get all lines of EnumDefinitions2.h which hold Enum | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep -e "[0-9]Enum" -e "[a-zA-Z]Enum" | grep -v include | sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Removed existing files
rm $ISSM_TIER/src/m/enum/*.m
rm $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
rm $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp

#Take care of EnumToModelField.m first (easy)
#Build EnumToModelField.m {{{1
cat <<END > $ISSM_TIER/src/m/enum/EnumToModelField.m
function string=EnumToModelField(enum)
%ENUMTOMODELFIELD - output string of model field associated to enum
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/EnumDefinitions/Synchronize.sh
%            Please read src/c/EnumDefinitions/README for more information
%
%   Usage:
%      string=EnumToModelField(enum)

switch enum,

END

cat EnumToModelField.cpp | grep "case" | sed -e "s/Enum :/Enum(),/g" -e "s/\"/'/g" -e "s/return /string=/g" -e "s/;/; return/g" >> EnumToModelField.m

cat <<END >> EnumToModelField.m
		otherwise, error(['Enum ' num2str(enum)  ' not found associated to any model field']);

end
END
#}}}
#Build EnumToStringx.cpp {{{1
#Header
cat <<END >  $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
/*
* \file EnumToStringx.cpp:
* \brief: output string associated with enum
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "./EnumToStringx.h"

char* EnumToStringx(int en){

	switch(en){

END
#core
cat temp |  awk '{print "\t\t" "case " $2" : return \"" substr($2,1,length($2)-4) "\";"}' >> $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
#Footer
cat <<END >> $ISSM_TIER/src/c/modules/EnumToStringx/EnumToStringx.cpp
		default : return "unknown";

	}
}
END
#}}}
#Build StringToEnumx.cpp {{{1
#Header
cat <<END > $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp
/*
* \file StringToEnumx.cpp:
* \brief: output enum associated with string
*
*   WARNING: DO NOT MODIFY THIS FILE
*            this file has been automatically generated by Synchronize.sh
*            Please read README for more information
*/

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "./StringToEnumx.h"

int  StringToEnumx(char* name){

END
#core
cat temp |  awk '{print "\t" ((NR==1)?"if":"else if") " (strcmp(name,\"" substr($2,1,length($2)-4) "\")==0) return " $2 ";"}' >> $ISSM_TIER//src/c/modules/StringToEnumx/StringToEnumx.cpp
#Footer
cat <<END >> $ISSM_TIER/src/c/modules/StringToEnumx/StringToEnumx.cpp
	else _error_("Enum %s not found",name);

}
END
#}}}

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for (( i=1 ; i<=$NUMBEROFLINES ; i++ )); do

	#Get name and enum of the line i
	NAMEENUM=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}');
	NAME=$(echo $NAMEENUM | sed -e "s/Enum//g")
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info {{{
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES Adding "$NAME"..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES Adding "$NAME"..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES Adding "$NAME"..."
		fi
	fi
	#}}}
	#Add case to matlabenum file{{{
	cat <<END > $ISSM_TIER"/src/m/enum/"$(echo $NAMEENUM".m")
function macro=$(echo $NAMEENUM)()
%$(echo $NAMEENUM | awk {'print toupper($1)'}) - Enum of $(echo $NAME)
%
%   WARNING: DO NOT MODIFY THIS FILE
%            this file has been automatically generated by src/c/EnumDefinitions/Synchronize.sh
%            Please read src/c/EnumDefinitions/README for more information
%
%   Usage:
%      macro=$NAMEENUM()

macro=StringToEnum('$NAME');
END
#}}}

done


#clean up{{{
rm temp
#}}}
#print info {{{
printf "\r                                                                      "
printf "\rdone!\n"
#}}}
