function md=SetIceSheetBC(md)
%SETICESHEETBC - Create the boundary conditions for diagnostic and thermal models for an IceSheet with no Ice Front
%
%   Usage:
%      md=SetIceSheetBC(md)
%
%   See also: SETICESHELFBC, SETMARINEICESHEETBC

%grid on Dirichlet
pos=find(md.gridonboundary);
md.spcvelocity=zeros(md.numberofgrids,6);
md.spcvelocity(pos,1:3)=1;
md.diagnostic_ref=NaN*ones(md.numberofgrids,6);

%Dirichlet Values
if (length(md.vx_obs)==md.numberofgrids & length(md.vy_obs)==md.numberofgrids)
	disp('      boundary conditions for diagnostic model: spc set as observed velocities');
	md.spcvelocity(:,4:5)=[md.vx_obs md.vy_obs]; %vz is zero
else
	disp('      boundary conditions for diagnostic model: spc set as zero');
end

%segment on neumann (Ice Front) -> none
if (md.dim==2)
	md.pressureload=zeros(0,4);
else
	md.pressureload=zeros(0,6);
end

%Create zeros melting_rate and accumulation_rate if not specified
if isnan(md.accumulation_rate),
	md.accumulation_rate=zeros(md.numberofgrids,1);
	disp('      no accumulation_rate specified: values set as zero');
end
if isnan(md.melting_rate),
	md.melting_rate=zeros(md.numberofgrids,1);
	disp('      no melting_rate specified: values set as zero');
end
if isnan(md.dhdt),
	md.dhdt=zeros(md.numberofgrids,1);
	disp('      no dhdt specified: values set as zero');
end

md.spcthickness=zeros(md.numberofgrids,2);

if (length(md.observed_temperature)==md.numberofgrids),
	md.spctemperature=[md.gridonsurface md.observed_temperature]; %impose observed temperature on surface
	if (length(md.geothermalflux)~=md.numberofgrids),
		md.geothermalflux=50*10^-3*ones(md.numberofgrids,1); %50 mW/m^2
	end
else
	disp('      no thermal boundary conditions created: no observed temperature found');
end
