%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006
printingflag=false;

L_list={5000,10000,20000,40000,80000,160000};
results={};
minvx=[];
maxvx=[];

for i=1:length(L_list),
	L=L_list{i};
	nx=30; %numberof nodes in x direction
	ny=30;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPD.par');
	md=extrude(md,10,1);

	md=setelementstype(md,'pattyn','all');

	%We need one grd on dirichlet: the 4 corners are set to zero
	md.spcvelocity=zeros(md.numberofgrids,6);

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0 & ~(md.y==0 & md.gridonbed) & ~(md.y==L & md.gridonbed));
	posx2=find(md.x==max(md.x) & ~(md.y==0 & md.gridonbed) & ~(md.y==L & md.gridonbed));

	posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
	posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

	md.penalties=[posx,posx2;posy,posy2];

	%Add spc on the corners
	pos=find((md.x==0 | md.x==L) & (md.y==0 | md.y==L) & md.gridonbed);
	md.spcvelocity(:,2)=1;
	md.spcvelocity(pos,1:2)=1;
	if(L==5000),
		md.spcvelocity(pos,4)=16.0912;
	elseif(L==10000),
		md.spcvelocity(pos,4)=16.52;
	elseif(L==20000),
		md.spcvelocity(pos,4)=17.77;
	elseif(L==40000),
		md.spcvelocity(pos,4)=19.88;
	elseif(L==80000),
		md.spcvelocity(pos,4)=18.65;
	elseif(L==160000),
		md.spcvelocity(pos,4)=16.91;
	end
	
	%Spc the bed at zero for vz
	pos=find(md.gridonbed);
	md.spcvelocity(pos,3)=1;

	%Compute the diagnostic
	md=solve(md,'analysis_type',DiagnosticSolutionEnum);

	%Plot the results and save them
	vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;
	minvx(i)=min(vx(end-md.numberofgrids2d+1:end));
	maxvx(i)=max(vx(end-md.numberofgrids2d+1:end));

	%Now plot vx, vy, vz and vx on a cross section
	plotmodel(md,'data',vx,'layer#all',md.numlayers,'xlim',[0 L/10^3],'ylim',[0 L/10^3],'unit','km','figure',2)
	if printingflag, 
		set(gcf,'Color','w')
		printmodel(['ismipdpattynvx' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipdpattynvx' num2str(L) '.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestD ']);
	end
	plotmodel(md,'data',vz,'layer#all',md.numlayers,'xlim',[0 L/10^3],'ylim',[0 L/10^3],'unit','km','figure',3)
	if printingflag, 
		set(gcf,'Color','w')
		printmodel(['ismipdpattynvz' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipdpattynvz' num2str(L) '.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestD ']);
	end

	if(L==5000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP5000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 20],'xlim',[0 5000],'title','','xlabel','','figure',4)
	elseif(L==10000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP10000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 20],'xlim',[0 10000],'title','','xlabel','','figure',4)
	elseif(L==20000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP20000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 30],'xlim',[0 20000],'title','','xlabel','','figure',4)
	elseif(L==40000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP40000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[10 60],'xlim',[0 40000],'title','','xlabel','','figure',4)
	elseif(L==80000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP80000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 200],'xlim',[0 80000],'title','','xlabel','','figure',4)
	elseif(L==160000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP160000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 400],'xlim',[0 160000],'title','','xlabel','','figure',4)
	end
	if printingflag, 
		set(gcf,'Color','w')
		printmodel(['ismipdpattynvxsec' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
		system(['mv ismipdpattynvxsec' num2str(L) '.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestD ']);
	end
end

%Now plot the min and max values of vx for each size of the square
plot([5 10 20 40 80 160],minvx);ylim([2 18]);xlim([0 160])
if printingflag, 
	set(gcf,'Color','w')
	printmodel('ismipdpattynminvx','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
	system(['mv ismipdpattynminvx.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestD ']);
end
plot([5 10 20 40 80 160],maxvx);ylim([0 300]);xlim([0 160])
if printingflag, 
	set(gcf,'Color','w')
	printmodel('ismipdpattynmaxvx','png','margin','on','marginsize',25,'frame','off','resolution',1.5,'hardcopy','off');
	system(['mv ismipdpattynmaxvx.png ' ISSM_DIR '/website/doc_pdf/validation/Images/ISMIP/TestD ']);
end
%Fields and tolerances to track changes
field_names     ={...
	'Vx5km','Vy5km','Vz5km',...
	'Vx10km','Vy10km','Vz10km',...
	'Vx20km','Vy20km','Vz20km',...
	'Vx40km','Vy40km','Vz40km',...
	'Vx80km','Vy80km','Vz80km',...
	'Vx160km','Vy160km','Vz160km'
};
field_tolerances={...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
	1e-08,1e-08,1e-08,...
};
field_values={};
for i=1:6,
	result=results{i};
	field_values={field_values{:},...
		PatchToVec(result.Vx),...
		PatchToVec(result.Vy),...
		PatchToVec(result.Vz),...
		};
end
