/*!\file GetVectorFromInputsx
 * \brief retrieve vector from inputs in elements
 */

#include "./GetVectorFromInputsx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void GetVectorFromInputsx( Vec* pvector, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int name, int type){


	int i;
	Vec vector=NULL;

	if(type==VertexEnum){

		vector=NewVec(vertices->NumberOfVertices());
		for(i=0;i<elements->Size();i++){
			Element* element=(Element*)elements->GetObjectByOffset(i);
			element->GetVectorFromInputs(vector,name);
		}
	}
	else _error_("%s%s%s"," vector type: ",EnumToStringx(type)," not supported yet!");

	VecAssemblyBegin(vector);
	VecAssemblyEnd(vector);

	/*Assign output pointers:*/
	*pvector=vector;

}

void GetVectorFromInputsx( double** pvector, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters, int name, int type){
	
	/*output: */
	double* vector=NULL;
	
	/*intermediary: */
	Vec vec_vector=NULL;

	GetVectorFromInputsx( &vec_vector, elements,nodes, vertices, loads, materials, parameters, name, type);
	VecToMPISerial(&vector,vec_vector);

	/*Free ressources:*/
	VecFree(&vec_vector);

	/*Assign output pointers:*/
	*pvector=vector;
}
