/*! \file KML_PolyStyle.h 
 *  \brief: header file for kml_polystyle object
 */

#ifndef _KML_POLYSTYLE_H_
#define _KML_POLYSTYLE_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_ColorStyle.h"
/*}}}*/

class KML_PolyStyle: public KML_ColorStyle {

	public:

		int   fill;
		int   outline;

		/*KML_PolyStyle constructors, destructors {{{1*/
		KML_PolyStyle();
		~KML_PolyStyle();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_POLYSTYLE_H */

