/*!\file KML_Placemark.cpp
 * \brief: implementation of the kml_placemark object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Placemark::KML_Placemark(){{{1*/
KML_Placemark::KML_Placemark(){

	geometry  =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Placemark::~KML_Placemark(){{{1*/
KML_Placemark::~KML_Placemark(){

	if (geometry) {
		delete geometry;
		geometry  =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Placemark::Echo {{{1*/
void  KML_Placemark::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Placemark:\n");
	KML_Feature::Echo();

	_printf_(flag,"      geometry: (size=%d)\n" ,geometry->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::DeepEcho {{{1*/
void  KML_Placemark::DeepEcho(){

	char  indent[81]="";

	KML_Placemark::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::DeepEcho {{{1*/
void  KML_Placemark::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Placemark:\n",indent);
	KML_Feature::DeepEcho(indent);

/*  loop over the geometry elements for the placemark  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (geometry->Size())
		for (i=0; i<geometry->Size(); i++) {
			_printf_(flag,"%s      geometry: [%d] begin\n" ,indent,i);
			((KML_Geometry *)geometry->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s      geometry: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s      geometry: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::Write {{{1*/
void  KML_Placemark::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<Placemark id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<Placemark>\n",indent);

	KML_Feature::Write(filout,indent);

/*  loop over the geometry elements for the placemark  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	for (i=0; i<geometry->Size(); i++)
		((KML_Geometry *)geometry->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</Placemark>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::Read {{{1*/
void  KML_Placemark::Read(FILE* filin,char* kstr){


	return;
}
/*}}}*/

/*FUNCTION KML_Placemark::Id {{{1*/
int   KML_Placemark::Id(){
}
/*}}}*/

/*FUNCTION KML_Placemark::MyRank {{{1*/
int   KML_Placemark::MyRank(){
}
/*}}}*/

/*FUNCTION KML_Placemark::Marshall {{{1*/
void  KML_Placemark::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Placemark::MarshallSize {{{1*/
int   KML_Placemark::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_Placemark::Demarshall {{{1*/
void  KML_Placemark::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Placemark::Enum {{{1*/
int   KML_Placemark::Enum(){
}
/*}}}*/

/*FUNCTION KML_Placemark::copy {{{1*/
Object* KML_Placemark::copy(){
}
/*}}}*/

