/*! \file KML_LineString.h 
 *  \brief: header file for kml_linestring object
 */

#ifndef _KML_LINESTRING_H_
#define _KML_LINESTRING_H_

#define KML_LINESTRING_ALTMODE_LENGTH    18

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Geometry.h"
/*}}}*/

class KML_LineString: public KML_Geometry {

	public:

		bool  extrude;
		bool  tessellate;
		char  altmode[KML_LINESTRING_ALTMODE_LENGTH+1];
        int   ncoord;
		double (*coords)[3];

		/*KML_LineString constructors, destructors {{{1*/
		KML_LineString();
		~KML_LineString();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_LINESTRING_H */

