/*! \file KML_Document.h 
 *  \brief: header file for kml_document object
 */

#ifndef _KML_DOCUMENT_H_
#define _KML_DOCUMENT_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Container.h"
class KML_Feature;
class DataSet;
/*}}}*/

class KML_Document: public KML_Container {

	public:

		DataSet* feature;

		/*KML_Document constructors, destructors {{{1*/
		KML_Document();
		~KML_Document();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		void  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_DOCUMENT_H */

