/*!\file KML_Polygon.cpp
 * \brief: implementation of the kml_polygon object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Polygon::KML_Polygon(){{{1*/
KML_Polygon::KML_Polygon(){

	extrude   =false;
	tessellate=false;
	strcpy(altmode   ,"clampToGround");
	outer     =new DataSet;
	inner     =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Polygon::~KML_Polygon(){{{1*/
KML_Polygon::~KML_Polygon(){

	if (inner) {
		delete inner;
		inner     =NULL;
	}

	if (outer) {
		delete outer;
		outer     =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Polygon::Echo {{{1*/
void  KML_Polygon::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Polygon:\n");
	KML_Geometry::Echo();

	_printf_(flag,"       extrude: %s\n"          ,(extrude ? "true" : "false"));
	_printf_(flag,"    tessellate: %s\n"          ,(tessellate ? "true" : "false"));
	_printf_(flag,"       altmode: \"%s\"\n"      ,altmode);
	_printf_(flag,"         outer: (size=%d)\n"   ,outer->Size());
	_printf_(flag,"         inner: (size=%d)\n"   ,inner->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::DeepEcho {{{1*/
void  KML_Polygon::DeepEcho(){

	char  indent[81]="";

	KML_Polygon::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::DeepEcho {{{1*/
void  KML_Polygon::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Polygon:\n",indent);
	KML_Geometry::DeepEcho(indent);

	_printf_(flag,"%s       extrude: %s\n"          ,indent,(extrude ? "true" : "false"));
	_printf_(flag,"%s    tessellate: %s\n"          ,indent,(tessellate ? "true" : "false"));
	_printf_(flag,"%s       altmode: \"%s\"\n"      ,indent,altmode);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (outer->Size())
		for (i=0; i<outer->Size(); i++) {
			_printf_(flag,"%s         outer: [%d] begin\n" ,indent,i);
			((KML_LinearRing *)outer->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s         outer: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s         outer: [empty]\n"    ,indent);

	if (inner->Size())
		for (i=0; i<inner->Size(); i++) {
			_printf_(flag,"%s         inner: [%d] begin\n" ,indent,i);
			((KML_LinearRing *)inner->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s         inner: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s         inner: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::Write {{{1*/
void  KML_Polygon::Write(FILE* filout,char* indent){

	int   i;
	char  indent4[81];

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<Polygon id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<Polygon>\n",indent);

	KML_Geometry::Write(filout,indent);

	fprintf(filout,"%s  <extrude>%d</extrude>\n",indent,(extrude ? 1 : 0));
	fprintf(filout,"%s  <tessellate>%d</tessellate>\n",indent,(tessellate ? 1 : 0));
	fprintf(filout,"%s  <altitudeMode>%s</altitudeMode>\n",indent,altmode);

	strcpy(indent4,indent);
	strcat(indent4,"    ");

	fprintf(filout,"%s  <outerBoundaryIs>\n",indent);
	if (outer->Size())
		((KML_LinearRing *)outer->GetObjectByOffset(0))->Write(filout,indent4);
	fprintf(filout,"%s  </outerBoundaryIs>\n",indent);

/*  loop over any inner boundaries for the polygon  */

	for (i=0; i<inner->Size(); i++) {
		fprintf(filout,"%s  <innerBoundaryIs>\n",indent);
		((KML_LinearRing *)inner->GetObjectByOffset(i))->Write(filout,indent4);
		fprintf(filout,"%s  </innerBoundaryIs>\n",indent);
	}

	fprintf(filout,"%s</Polygon>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::Read {{{1*/
void  KML_Polygon::Read(FILE* filin,char* kstr){


	return;
}
/*}}}*/

/*FUNCTION KML_Polygon::Id {{{1*/
int   KML_Polygon::Id(){
}
/*}}}*/

/*FUNCTION KML_Polygon::MyRank {{{1*/
int   KML_Polygon::MyRank(){
}
/*}}}*/

/*FUNCTION KML_Polygon::Marshall {{{1*/
void  KML_Polygon::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Polygon::MarshallSize {{{1*/
int   KML_Polygon::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_Polygon::Demarshall {{{1*/
void  KML_Polygon::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Polygon::Enum {{{1*/
int   KML_Polygon::Enum(){
}
/*}}}*/

/*FUNCTION KML_Polygon::copy {{{1*/
Object* KML_Polygon::copy(){
}
/*}}}*/

