/*! \file KML_StyleSelector.h 
 *  \brief: header file for kml_styleselector abstract object
 */

#ifndef _KML_STYLESELECTOR_H_
#define _KML_STYLESELECTOR_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Object.h"
/*}}}*/

class KML_StyleSelector: public KML_Object {

	public:

		/*KML_StyleSelector constructors, destructors {{{1*/
		KML_StyleSelector();
		~KML_StyleSelector();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		KML_Object*  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_STYLESELECTOR_H */

