/*! \file KML_Polygon.h 
 *  \brief: header file for kml_polygon object
 */

#ifndef _KML_POLYGON_H_
#define _KML_POLYGON_H_

#define KML_POLYGON_ALTMODE_LENGTH    18

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Geometry.h"
class KML_LinearRing;
class DataSet;
/*}}}*/

class KML_Polygon: public KML_Geometry {

	public:

		bool  extrude;
		bool  tessellate;
		char  altmode[KML_POLYGON_ALTMODE_LENGTH+1];
		DataSet* outer;
		DataSet* inner;

		/*KML_Polygon constructors, destructors {{{1*/
		KML_Polygon();
		~KML_Polygon();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		KML_Object*  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_POLYGON_H */

