/*!\file KML_PolyStyle.cpp
 * \brief: implementation of the kml_polystyle object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_PolyStyle::KML_PolyStyle(){{{1*/
KML_PolyStyle::KML_PolyStyle(){

	fill      =true;
	outline   =true;

}
/*}}}*/
/*FUNCTION KML_PolyStyle::~KML_PolyStyle(){{{1*/
KML_PolyStyle::~KML_PolyStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_PolyStyle::Echo {{{1*/
void  KML_PolyStyle::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_PolyStyle:\n");
	KML_ColorStyle::Echo();

	_printf_(flag,"          fill: %d\n"          ,fill);
	_printf_(flag,"       outline: %d\n"          ,outline);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::DeepEcho {{{1*/
void  KML_PolyStyle::DeepEcho(){

	char  indent[81]="";

	KML_PolyStyle::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::DeepEcho {{{1*/
void  KML_PolyStyle::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_PolyStyle:\n",indent);
	KML_ColorStyle::DeepEcho(indent);

	_printf_(flag,"%s          fill: %d\n"          ,indent,fill);
	_printf_(flag,"%s       outline: %d\n"          ,indent,outline);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Write {{{1*/
void  KML_PolyStyle::Write(FILE* filout,char* indent){

	int   i;

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<PolyStyle id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<PolyStyle>\n",indent);

	KML_ColorStyle::Write(filout,indent);

	fprintf(filout,"%s  <fill>%d</fill>\n",indent,fill);
	fprintf(filout,"%s  <outline>%d</outline>\n",indent,outline);

	fprintf(filout,"%s</PolyStyle>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Read {{{1*/
KML_Object*  KML_PolyStyle::Read(FILE* filin,char* kstr){


	return(NULL);
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Id {{{1*/
int   KML_PolyStyle::Id(){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::MyRank {{{1*/
int   KML_PolyStyle::MyRank(){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Marshall {{{1*/
void  KML_PolyStyle::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::MarshallSize {{{1*/
int   KML_PolyStyle::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Demarshall {{{1*/
void  KML_PolyStyle::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::Enum {{{1*/
int   KML_PolyStyle::Enum(){
}
/*}}}*/

/*FUNCTION KML_PolyStyle::copy {{{1*/
Object* KML_PolyStyle::copy(){
}
/*}}}*/

