/*!\file KML_LineStyle.cpp
 * \brief: implementation of the kml_linestyle object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_LineStyle::KML_LineStyle(){{{1*/
KML_LineStyle::KML_LineStyle(){

	width     =1;

}
/*}}}*/
/*FUNCTION KML_LineStyle::~KML_LineStyle(){{{1*/
KML_LineStyle::~KML_LineStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_LineStyle::Echo {{{1*/
void  KML_LineStyle::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_LineStyle:\n");
	KML_ColorStyle::Echo();

	_printf_(flag,"         width: %d\n"          ,width);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::DeepEcho {{{1*/
void  KML_LineStyle::DeepEcho(){

	char  indent[81]="";

	KML_LineStyle::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::DeepEcho {{{1*/
void  KML_LineStyle::DeepEcho(char* indent){

	int   i;
	bool  flag=true;

	_printf_(flag,"%sKML_LineStyle:\n",indent);
	KML_ColorStyle::DeepEcho(indent);

	_printf_(flag,"%s         width: %d\n"          ,indent,width);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::Write {{{1*/
void  KML_LineStyle::Write(FILE* filout,char* indent){

	int   i;

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<LineStyle id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<LineStyle>\n",indent);

	KML_ColorStyle::Write(filout,indent);

	fprintf(filout,"%s  <width>%d</width>\n",indent,width);

	fprintf(filout,"%s</LineStyle>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_LineStyle::Read {{{1*/
KML_Object*  KML_LineStyle::Read(FILE* filin,char* kstr){


	return(NULL);
}
/*}}}*/

/*FUNCTION KML_LineStyle::Id {{{1*/
int   KML_LineStyle::Id(){
}
/*}}}*/

/*FUNCTION KML_LineStyle::MyRank {{{1*/
int   KML_LineStyle::MyRank(){
}
/*}}}*/

/*FUNCTION KML_LineStyle::Marshall {{{1*/
void  KML_LineStyle::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_LineStyle::MarshallSize {{{1*/
int   KML_LineStyle::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_LineStyle::Demarshall {{{1*/
void  KML_LineStyle::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_LineStyle::Enum {{{1*/
int   KML_LineStyle::Enum(){
}
/*}}}*/

/*FUNCTION KML_LineStyle::copy {{{1*/
Object* KML_LineStyle::copy(){
}
/*}}}*/

