/*! \file KML_Geometry.h 
 *  \brief: header file for kml_geometry abstract object
 */

#ifndef _KML_GEOMETRY_H_
#define _KML_GEOMETRY_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_Object.h"
/*}}}*/

class KML_Geometry: public KML_Object {

	public:

		/*KML_Geometry constructors, destructors {{{1*/
		KML_Geometry();
		~KML_Geometry();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		KML_Object*  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_GEOMETRY_H */

