/*!\file KML_Document.cpp
 * \brief: implementation of the kml_document object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Document::KML_Document(){{{1*/
KML_Document::KML_Document(){

	feature   =new DataSet;

}
/*}}}*/
/*FUNCTION KML_Document::~KML_Document(){{{1*/
KML_Document::~KML_Document(){

	if (feature) {
		delete feature;
		feature   =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Document::Echo {{{1*/
void  KML_Document::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Document:\n");
	KML_Container::Echo();

	_printf_(flag,"       feature: (size=%d)\n" ,feature->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_Document::DeepEcho {{{1*/
void  KML_Document::DeepEcho(){

	char  indent[81]="";

	KML_Document::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::DeepEcho {{{1*/
void  KML_Document::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Document:\n",indent);
	KML_Container::DeepEcho(indent);

/*  loop over the features for the document  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (feature->Size())
		for (i=0; i<feature->Size(); i++) {
			_printf_(flag,"%s       feature: [%d] begin\n" ,indent,i);
			((KML_Feature *)feature->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s       feature: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s       feature: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::Write {{{1*/
void  KML_Document::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<Document id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<Document>\n",indent);

	KML_Container::Write(filout,indent);

/*  loop over the features for the document  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	for (i=0; i<feature->Size(); i++)
		((KML_Feature *)feature->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</Document>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Document::Read {{{1*/
KML_Object*  KML_Document::Read(FILE* fid,char* kstr){

	char*        kstri;
	KML_Object*  kobj;

/*  check for id attribute  */

//	KML_Object::Read(fid,kstr);
	KMLFileTagAttrib( id        ,NULL,KML_OBJECT_ID_LENGTH,
					 kstr,
					 "id");

/*  loop over and process fields within opening and closing tags  */

	while (kstri=KMLFileToken(fid)) {
		if      (!strncmp(kstri,"</Document",10)) {
			xfree((void**)&kstri);
			break;
		}
		else if (!strncmp(kstri,"</",2))
			_error_("KML_Document::Read -- Unexpected closing tag %s.\n",kstri);
		else if (strncmp(kstri,"<",1))
			_error_("KML_Document::Read -- Unexpected field \"%s\".\n",kstri);

		else if (!strncmp(kstri,"<Placemark",10)) {
			kobj=(KML_Object*)new KML_Placemark();
			kobj->Read(fid,kstri);
			feature   ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Folder",7)) {
			kobj=(KML_Object*)new KML_Folder();
			kobj->Read(fid,kstri);
			feature   ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<Document",9)) {
			kobj=(KML_Object*)new KML_Document();
			kobj->Read(fid,kstri);
			feature   ->AddObject((Object*)kobj);
		}

		else if (!strncmp(kstri,"<",1))
			KML_Container::Read(fid,kstri);

		xfree((void**)&kstri);
	}

	return(NULL);
}
/*}}}*/

/*FUNCTION KML_Document::Id {{{1*/
int   KML_Document::Id(){
}
/*}}}*/

/*FUNCTION KML_Document::MyRank {{{1*/
int   KML_Document::MyRank(){
}
/*}}}*/

/*FUNCTION KML_Document::Marshall {{{1*/
void  KML_Document::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Document::MarshallSize {{{1*/
int   KML_Document::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_Document::Demarshall {{{1*/
void  KML_Document::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Document::Enum {{{1*/
int   KML_Document::Enum(){
}
/*}}}*/

/*FUNCTION KML_Document::copy {{{1*/
Object* KML_Document::copy(){
}
/*}}}*/

