/*! \file KML_ColorStyle.h 
 *  \brief: header file for kml_colorstyle abstract object
 */

#ifndef _KML_COLORSTYLE_H_
#define _KML_COLORSTYLE_H_

#define KML_COLORSTYLE_COLOR_LENGTH      8
#define KML_COLORSTYLE_COLORMODE_LENGTH  6

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_SubStyle.h"
/*}}}*/

class KML_ColorStyle: public KML_SubStyle {

	public:

		char  color[KML_COLORSTYLE_COLOR_LENGTH+1];
		char  colormode[KML_COLORSTYLE_COLORMODE_LENGTH+1];

		/*KML_ColorStyle constructors, destructors {{{1*/
		KML_ColorStyle();
		~KML_ColorStyle();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		KML_Object*  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_COLORSTYLE_H */

