/*!\file KML_Object.cpp
 * \brief: implementation of the kml_object abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Object::KML_Object(){{{1*/
KML_Object::KML_Object(){

	strcpy(id        ,"");

}
/*}}}*/
/*FUNCTION KML_Object::~KML_Object(){{{1*/
KML_Object::~KML_Object(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Object::Echo {{{1*/
void  KML_Object::Echo(){

	bool  flag=true;

	_printf_(flag,"            id: \"%s\"\n"      ,id);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::DeepEcho {{{1*/
void  KML_Object::DeepEcho(){

	char  indent[81]="";

	KML_Object::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::DeepEcho {{{1*/
void  KML_Object::DeepEcho(char* indent){

	bool  flag=true;

	_printf_(flag,"%s            id: \"%s\"\n"      ,indent,id);

	return;
}
/*}}}*/

/*FUNCTION KML_Object::Write {{{1*/
void  KML_Object::Write(FILE* filout,char* indent){

//  id is always written in keyword line of derived classes

	;

	return;
}
/*}}}*/

/*FUNCTION KML_Object::Read {{{1*/
KML_Object*  KML_Object::Read(FILE* fid,char* kstr){

/*  process field within opening and closing tags  */

	if      (!strncmp(kstr,"</Object", 8))
		return(NULL);
	else if (!strncmp(kstr,"</",2))
		_error_("KML_Object::Read -- Unexpected closing tag %s.\n",kstr);
	else if (strncmp(kstr,"<",1))
		_error_("KML_Object::Read -- Unexpected field \"%s\".\n",kstr);

	else if (!strncmp(kstr,"<",1)) {
		_printf_(true,"KML_Object::Read -- Unrecognized opening tag %s.\n",kstr);
		KMLFileTagSkip(kstr,
					   fid);
	}

	return(NULL);
}
/*}}}*/

/*FUNCTION KML_Object::Id {{{1*/
int   KML_Object::Id(){
}
/*}}}*/

/*FUNCTION KML_Object::MyRank {{{1*/
int   KML_Object::MyRank(){
}
/*}}}*/

/*FUNCTION KML_Object::Marshall {{{1*/
void  KML_Object::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Object::MarshallSize {{{1*/
int   KML_Object::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_Object::Demarshall {{{1*/
void  KML_Object::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_Object::Enum {{{1*/
int   KML_Object::Enum(){
}
/*}}}*/

/*FUNCTION KML_Object::copy {{{1*/
Object* KML_Object::copy(){
}
/*}}}*/

