/*!\file KML_MultiGeometry.cpp
 * \brief: implementation of the kml_multigeometry object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_MultiGeometry::KML_MultiGeometry(){{{1*/
KML_MultiGeometry::KML_MultiGeometry(){

	geometry  =new DataSet;

}
/*}}}*/
/*FUNCTION KML_MultiGeometry::~KML_MultiGeometry(){{{1*/
KML_MultiGeometry::~KML_MultiGeometry(){

	if (geometry) {
		delete geometry;
		geometry  =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_MultiGeometry::Echo {{{1*/
void  KML_MultiGeometry::Echo(){

	bool  flag=true;

	_printf_(flag,"KML_Multigeometry:\n");
	KML_Geometry::Echo();

	_printf_(flag,"      geometry: (size=%d)\n" ,geometry->Size());

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::DeepEcho {{{1*/
void  KML_MultiGeometry::DeepEcho(){

	char  indent[81]="";

	KML_MultiGeometry::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::DeepEcho {{{1*/
void  KML_MultiGeometry::DeepEcho(char* indent){

	int   i;
	char  indent2[81];
	bool  flag=true;

	_printf_(flag,"%sKML_Multigeometry:\n",indent);
	KML_Geometry::DeepEcho(indent);

/*  loop over the geometry elements for the multigeometry  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (geometry->Size())
		for (i=0; i<geometry->Size(); i++) {
			_printf_(flag,"%s      geometry: [%d] begin\n" ,indent,i);
			((KML_Geometry *)geometry->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s      geometry: [%d] end\n"   ,indent,i);
		}
	else
		_printf_(flag,"%s      geometry: [empty]\n"    ,indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Write {{{1*/
void  KML_MultiGeometry::Write(FILE* filout,char* indent){

	int   i;
	char  indent2[81];

	if (this->id && strlen(this->id))
		fprintf(filout,"%s<MultiGeometry id=\"%s\">\n",indent,this->id);
	else
		fprintf(filout,"%s<MultiGeometry>\n",indent);

	KML_Geometry::Write(filout,indent);

/*  loop over the geometry elements for the multigeometry  */

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	for (i=0; i<geometry->Size(); i++)
		((KML_Geometry *)geometry->GetObjectByOffset(i))->Write(filout,indent2);

	fprintf(filout,"%s</MultiGeometry>\n",indent);

	return;
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Read {{{1*/
KML_Object*  KML_MultiGeometry::Read(FILE* filin,char* kstr){


	return(NULL);
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Id {{{1*/
int   KML_MultiGeometry::Id(){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::MyRank {{{1*/
int   KML_MultiGeometry::MyRank(){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Marshall {{{1*/
void  KML_MultiGeometry::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::MarshallSize {{{1*/
int   KML_MultiGeometry::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Demarshall {{{1*/
void  KML_MultiGeometry::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::Enum {{{1*/
int   KML_MultiGeometry::Enum(){
}
/*}}}*/

/*FUNCTION KML_MultiGeometry::copy {{{1*/
Object* KML_MultiGeometry::copy(){
}
/*}}}*/

