/*! \file KML_LineStyle.h 
 *  \brief: header file for kml_linestyle object
 */

#ifndef _KML_LINESTYLE_H_
#define _KML_LINESTYLE_H_

/*Headers:*/
/*{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./KML_ColorStyle.h"
/*}}}*/

class KML_LineStyle: public KML_ColorStyle {

	public:

		int   width;

		/*KML_LineStyle constructors, destructors {{{1*/
		KML_LineStyle();
		~KML_LineStyle();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		void  Write(FILE* fid,char* indent);
		KML_Object*  Read(FILE* fid,char* kstr);
		int   Id();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/

};
#endif  /* _KML_LINESTYLE_H */

