/*!\file KML_ColorStyle.cpp
 * \brief: implementation of the kml_colorstyle abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_ColorStyle::KML_ColorStyle(){{{1*/
KML_ColorStyle::KML_ColorStyle(){

	strcpy(color     ,"ffffffff");
	strcpy(colormode ,"normal");

}
/*}}}*/
/*FUNCTION KML_ColorStyle::~KML_ColorStyle(){{{1*/
KML_ColorStyle::~KML_ColorStyle(){

	;

}
/*}}}*/

/*Other*/
/*FUNCTION KML_ColorStyle::Echo {{{1*/
void  KML_ColorStyle::Echo(){

	bool  flag=true;

	KML_SubStyle::Echo();

	_printf_(flag,"         color: %s\n"          ,color);
	_printf_(flag,"     colormode: %s\n"          ,colormode);

	return;
}
/*}}}*/

/*FUNCTION KML_ColorStyle::DeepEcho {{{1*/
void  KML_ColorStyle::DeepEcho(){

	char  indent[81]="";

	KML_ColorStyle::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_ColorStyle::DeepEcho {{{1*/
void  KML_ColorStyle::DeepEcho(char* indent){

	bool  flag=true;

	KML_SubStyle::DeepEcho(indent);

	_printf_(flag,"%s         color: %s\n"          ,indent,color);
	_printf_(flag,"%s     colormode: %s\n"          ,indent,colormode);

	return;
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Write {{{1*/
void  KML_ColorStyle::Write(FILE* filout,char* indent){

	KML_SubStyle::Write(filout,indent);

	if (color     && strlen(color))
		fprintf(filout,"%s  <color>%s</color>\n",indent,color);
	if (colormode && strlen(colormode))
		fprintf(filout,"%s  <colorMode>%s</colorMode>\n",indent,colormode);

	return;
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Read {{{1*/
KML_Object*  KML_ColorStyle::Read(FILE* filin,char* kstr){


	return(NULL);
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Id {{{1*/
int   KML_ColorStyle::Id(){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::MyRank {{{1*/
int   KML_ColorStyle::MyRank(){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Marshall {{{1*/
void  KML_ColorStyle::Marshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::MarshallSize {{{1*/
int   KML_ColorStyle::MarshallSize(){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Demarshall {{{1*/
void  KML_ColorStyle::Demarshall(char** pmarshalled_dataset){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::Enum {{{1*/
int   KML_ColorStyle::Enum(){
}
/*}}}*/

/*FUNCTION KML_ColorStyle::copy {{{1*/
Object* KML_ColorStyle::copy(){
}
/*}}}*/

