/*!\file:  KMLFileReadUtils.h
 * \brief: header file for kml file reading utilities.
 */ 

#ifndef _KMLFILEREADUTILS_H
#define _KMLFILEREADUTILS_H

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "../Object.h"
/*}}}*/

/* local prototypes: */
char* KMLFileToken(FILE* fid);
void KMLFileTokenBuffer(char** pbuffer,int* pibuf,int* pbuflen,
						int c,
						int bufblk);
char* KMLFileTagAttrib(char* pstr,int *m,int maxlen,
					   char* ktag,
					   char* att);
int KMLFileTokenParse(int* pint,
					  char* ktag,
					  FILE* fid);
int KMLFileTokenParse(bool* pbool,
					  char* ktag,
					  FILE* fid);
char* KMLFileTokenParse(char* pstr,int *m,int maxlen,
					  char* ktag,
					  FILE* fid);
int KMLFileTokenParse(double (**pdoub3)[3],int* m,int maxlen,
					  char* ktag,
					  FILE* fid);
int KMLFileTagSkip(char* ktag,
				   FILE* fid);

#endif  /* _KMLFILEREADUTILS_H */

