#!/bin/sh
./configure \
	--prefix=$ISSM_TIER \
	--with-matlab-dir=$MATLAB_DIR \
	--with-triangle-dir=$ISSM_TIER/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_TIER/externalpackages/metis/install \
	--with-petsc-dir=$ISSM_TIER/externalpackages/petsc/install  \
	--with-petsc-version=3 \
	--with-mpi-include=$ISSM_TIER/externalpackages/mpich2/install/include  \
	--with-mpi-lib=" $ISSM_TIER/externalpackages/mpich2/install/lib/libpmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpich.a $ISSM_TIER/externalpackages/mpich2/install/lib/libmpl.a " \
	--with-petsc-arch=$ISSM_ARCH \
	--with-dakota-dir=$ISSM_TIER/externalpackages/dakota/install \
	--with-blas-lapack-dir=$ISSM_TIER/externalpackages/petsc/install \
	--with-plapack-lib="-L$ISSM_TIER/externalpackages/petsc/install/ -lPLAPACK" \
	--with-plapack-include="-I $ISSM_TIER/externalpackages/petsc/install/include/ " \
	--with-blacs-dir=$ISSM_TIER/externalpackages/petsc/install/ \
	--with-scalapack-dir=$ISSM_TIER/externalpackages/petsc/install/ \
	--with-mumps-dir=$ISSM_TIER/externalpackages/petsc/install/ \
	--with-fortran-lib="/usr/local/lib/libgfortran.a" \
	--with-math-lib="/usr/lib/libm.dylib" \
	--with-graphics-lib="/usr/X11/lib/libX11.dylib" \
	--with-cxxoptflags=" -DMATLAB_MEX_FILE -fno-common -no-cpp-precomp -fexceptions -DMX_COMPAT_32 -O3 -DNDEBUG -w " \
	--with-numthreads=8
