md=mesh(model,'../Exp/Pig.exp',30000);
md=geography(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp');
md=parameterize(md,'../Par/Pig.par');
md=extrude(md,3,1);
md=setelementstype(md,'macayeal','all');

%control parameters
md.control_analysis=1;
md.control_type=DragCoefficientEnum();
md.cm_min=1*ones(md.numberofgrids,1);
md.cm_max=200*ones(md.numberofgrids,1);
md.nsteps=2;
md.cm_responses=SurfaceLogVelMisfitEnum()*ones(md.nsteps,1);
md.weights=ones(md.numberofgrids,1);
md.optscal=3*ones(md.nsteps,1);
md.maxiter=2*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);
md.cm_noisedmp=2*10^-7;
md.vx_obs=md.vx; md.vy_obs=md.vy;
md.dt=0;

md=SetParallel(md,3);
md=solve(md,'analysis_type',SteadystateSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'DragCoefficient' 'Pressure' 'Vel' 'Vx' 'Vy' 'Vz' 'Temperature' 'MeltingRate'};
field_tolerances={1e-10,1e-10,1e-10,1e-10,1e-6,1e-6,1e-6,1e-6,1e-6,1e-06};
field_values={...
	PatchToVec(md.results.SteadystateSolution.Gradient1),...
	md.results.SteadystateSolution.J,...
	PatchToVec(md.results.SteadystateSolution.DragCoefficient),...
	PatchToVec(md.results.SteadystateSolution.Pressure),...
	PatchToVec(md.results.SteadystateSolution.Vel),...
	PatchToVec(md.results.SteadystateSolution.Vx),...
	PatchToVec(md.results.SteadystateSolution.Vy),...
	PatchToVec(md.results.SteadystateSolution.Vz),...
	PatchToVec(md.results.SteadystateSolution.Temperature),...
	PatchToVec(md.results.SteadystateSolution.MeltingRate)
};
