md=mesh(model,'../Exp/79North.exp',10000);
md=meshconvert(md);
md=geography(md,'../Exp/79NorthShelf.exp','');
md=parameterize(md,'../Par/79North.par');
md=setelementstype(md,'macayeal','all');

%control parameters
md.nsteps=2;
md.prognostic_DG=1;
md.control_analysis=1;
md.control_type=DhDtEnum;
md.thickness_obs=md.thickness;
md.cm_min=-50*ones(md.numberofgrids,1);
md.cm_max=50*ones(md.numberofgrids,1);
md.cm_responses=ThicknessAbsMisfitEnum*ones(md.nsteps,1);
md.weights=ones(md.numberofgrids,1);
md.optscal=10/md.yts*ones(md.nsteps,1);
md.maxiter=4*ones(md.nsteps,1);
md.cm_jump=0.99*ones(md.nsteps,1);

md=SetParallel(md,3);
md=solve(md,'analysis_type',BalancedthicknessSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Gradient' 'Misfits' 'DhDt' 'Thickness'};
field_tolerances={1e-12,1e-12,1e-12,1e-12,1e-12,1e-12};
field_values={...
	PatchToVec(md.results.BalancedthicknessSolution.Gradient1),...
	md.results.BalancedthicknessSolution.J,...
	PatchToVec(md.results.BalancedthicknessSolution.DhDt),...
	PatchToVec(md.results.BalancedthicknessSolution.Thickness)
};
