/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type){
	
	int i;
	Parameters* parameters=NULL;

	/*Get parameters: */
	parameters=*pparameters;
	parameters->AddObject(new   BoolParam(ControlAnalysisEnum,iomodel->control_analysis));

	if(iomodel->control_analysis){

		/*How many controls?*/
		parameters->AddObject(new IntParam(NumControlsEnum,iomodel->num_control_type));

		/*What control type?*/
		IoModelFetchData(&iomodel->control_type,NULL,NULL,iomodel_handle,"control_type");
		parameters->AddObject(new IntVecParam(ControlTypeEnum,iomodel->control_type,iomodel->num_control_type));
		xfree((void**)&iomodel->control_type);

		/*What solution type?*/
		if (solution_type==SteadystateSolutionEnum){
			parameters->AddObject(new BoolParam(ControlSteadyEnum,true));
		}
		else{
			parameters->AddObject(new BoolParam(ControlSteadyEnum,false));
		}
		parameters->AddObject(new IntParam(NStepsEnum,iomodel->nsteps));
		parameters->AddObject(new DoubleParam(TolXEnum,iomodel->tolx));
		parameters->AddObject(new DoubleParam(EpsCmEnum,iomodel->eps_cm));
		parameters->AddObject(new DoubleParam(MeanVelEnum,iomodel->meanvel));
		parameters->AddObject(new DoubleParam(CmNoiseDmpEnum,iomodel->cm_noisedmp));

		parameters->AddObject(new BoolParam(CmGradientEnum,iomodel->cm_gradient));

		/*Now, recover fit, optscal and maxiter as vectors: */
		IoModelFetchData(&iomodel->cm_responses,NULL,NULL,iomodel_handle,"cm_responses");
		IoModelFetchData(&iomodel->cm_jump,NULL,NULL,iomodel_handle,"cm_jump");
		IoModelFetchData(&iomodel->optscal,NULL,NULL,iomodel_handle,"optscal");
		IoModelFetchData(&iomodel->maxiter,NULL,NULL,iomodel_handle,"maxiter");

		parameters->AddObject(new DoubleVecParam(CmResponsesEnum,iomodel->cm_responses,iomodel->nsteps));
		parameters->AddObject(new DoubleVecParam(CmJumpEnum,iomodel->cm_jump,iomodel->nsteps));
		parameters->AddObject(new DoubleMatParam(OptScalEnum,iomodel->optscal,iomodel->nsteps,iomodel->num_control_type));
		parameters->AddObject(new DoubleVecParam(MaxIterEnum,iomodel->maxiter,iomodel->nsteps));

		xfree((void**)&iomodel->cm_responses);
		xfree((void**)&iomodel->cm_jump);
		xfree((void**)&iomodel->optscal);
		xfree((void**)&iomodel->maxiter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
