/*!\file:  DakotaPlugin.h:
 */ 

#ifndef DAKOTAPLUGIN_H
#define DAKOTAPLUGIN_H


#ifdef _HAVE_DAKOTA_ //only works if dakota library has been compiled in.

#include "DirectApplicInterface.H"
#include "../toolkits/toolkits.h"
#include "../objects/objects.h"

namespace SIM {

class DakotaPlugin: public Dakota::DirectApplicInterface
{
public:

  DakotaPlugin(const Dakota::ProblemDescDB& problem_db,FemModel* femmodels, ParameterInputs* inputs, int analysis_type, int sub_analysis_type);
  ~DakotaPlugin();
  
  /*these fields are use by core solutions: */
  FemModel* femmodels;
  ParameterInputs* inputs;
  int analysis_type;
  int sub_analysis_type;
  int counter;

protected:

  // execute the input filter portion of a direct evaluation invocation
  //int derived_map_if(const Dakota::String& if_name);
  /// execute an analysis code portion of a direct evaluation invocation
  int derived_map_ac(const Dakota::String& ac_name);
  // execute the output filter portion of a direct evaluation invocation
  //int derived_map_of(const Dakota::String& of_name);

  /*add for issm: */
  int GetCounter();

private:

};

} // namespace SIM

#endif //only works if dakota library has been compiled in.


#endif
