#!/bin/bash
#Generate a RTF file with references provided in CITE
#Version: 04/27/11

#Genetare a pdf with the list of references provided in $CITE
CITE="Joughin2009,Rignot2002"

#First erase files; 
rm -rf references.rtf

#create Latex file
cat <<END > references.tex
\documentclass[letterpaper]{article}
\makeatletter
%\renewcommand\@biblabel[1]{#1.}     % Arabic numbers, no brackets
%\renewcommand\@biblabel[1]{$^{#1}$} % Superscripts
\renewcommand\@biblabel[1]{}         % No label
\makeatother
\bibliographystyle{plain}
\begin{document}
\nocite{$CITE}
\bibliography{$ISSM_DIR/publications/bibtex/references}
\end{document}
END
#Generate pdf
echo "Compiling document"
latex  -interaction=batchmode -file-line-error references.tex > /dev/null
echo "Running Bibtex"
bibtex references
echo "Converting to rtf"
$ISSM_TIER/externalpackages/latex2rtf/install/latex2rtf -P $ISSM_TIER/externalpackages/latex2rtf/install/cfg/ references

#Remove all but rtf file
rm -rf references.[!rtf]*
rm -rf references.tex
