function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

%load result onto model
if ~isstruct(md.results),
	if isnan(md.results), md.results=struct(); end 
end
eval(['md.results.' md.analysis_type '=parseresultsfromdisk(filename);']);

%Check result is consistent, only if it exists
if ~isempty(md.results.diagnostic),
	disp(sprintf('%s\n','checking result consistency'));
	if ~isresultconsistent(md,md.analysis_type),
		%it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
		disp('!! results not consistent correct the model !!') 
	end
end

%deal with qmu results
if md.qmu_analysis, 
	md=qmuoutput(md,md.name,'qmu');
end
