/*!\file:  DakotaResponses.cpp
 * \brief  compute dakota responses, using a list of response descriptors.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../DataSet/DataSet.h"    
#include "../shared/shared.h"

#undef __FUNCT__ 
#define __FUNCT__ "DakotaResponses"
void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,FemModel* femmodels,DataSet* results,int analysis_type,int sub_analysis_type){

	int i,j;
	int found=0;
	char* response_descriptor=NULL;
	int numberofnodes;
	FemModel* fem=NULL;
	extern int my_rank;

	/*recover first model: */
	fem=femmodels;

	/*some data needed across the responses: */
	found=fem->parameters->FindParam((void*)&numberofnodes,"numberofnodes");
	if(!found)throw ErrorException(__FUNCT__," could not find numberofnodes in fem model");


	for(i=0;i<numresponses;i++){

		response_descriptor=responses_descriptors[i];

		//'min_vx' 'max_vx' 'max_abs_vx' 'min_vy' 'max_vy' 'max_abs_vy' 'min_vel' 'max_vel'

		if(strcmp(response_descriptor,"min_vel")==0){
			double* vel=NULL;
			double min_vel=0;
		
			found=results->FindResult((void*)&vel,"vel");
			if(!found)throw ErrorException(__FUNCT__," could not find vel to compute min_vel");

			min_vel=vel[0];
			for(j=1;j<numberofnodes;j++){
				if (vel[j]<min_vel)min_vel=vel[j];
			}

			if(my_rank==0)responses[i]=min_vel;
			
		}
		else if(strcmp(response_descriptor,"max_vel")==0){
			double* vel=NULL;
			double max_vel=0;

			found=results->FindResult((void*)&vel,"vel");
			if(!found)throw ErrorException(__FUNCT__," could not find vel to compute max_vel");

			max_vel=vel[0];
			for(j=1;j<numberofnodes;j++){
				if (vel[j]>max_vel)max_vel=vel[j];
			}
			if(my_rank==0)responses[i]=max_vel;
		}
		else if(strcmp(response_descriptor,"min_vx")==0){
			double* vx=NULL;
			double min_vx=0;
			
			found=results->FindResult((void*)&vx,"vx");
			if(!found)throw ErrorException(__FUNCT__," could not find vx to compute min_vx");

			min_vx=vx[0];
			for(j=1;j<numberofnodes;j++){
				if (vx[j]<min_vx)min_vx=vx[j];
			}
			if(my_rank==0)responses[i]=min_vx;
		}
		else if(strcmp(response_descriptor,"max_vx")==0){
			double* vx=NULL;
			double max_vx=0;
			
			found=results->FindResult((void*)&vx,"vx");
			if(!found)throw ErrorException(__FUNCT__," could not find vx to compute max_vx");

			max_vx=vx[0];
			for(j=1;j<numberofnodes;j++){
				if (vx[j]>max_vx)max_vx=vx[j];
			}
			if(my_rank==0)responses[i]=max_vx;
		}
		else if(strcmp(response_descriptor,"max_abs_vx")==0){
			double* vx=NULL;
			double max_abs_vx=0;
			
			found=results->FindResult((void*)&vx,"vx");
			if(!found)throw ErrorException(__FUNCT__," could not find vx to compute max_abs_vx");

			max_abs_vx=fabs(vx[0]);
			for(j=1;j<numberofnodes;j++){
				if (fabs(vx[j])>max_abs_vx)max_abs_vx=fabs(vx[j]);
			}
			if(my_rank==0)responses[i]=max_abs_vx;
		}
		else if(strcmp(response_descriptor,"min_vy")==0){
			double* vy=NULL;
			double min_vy=0;
			
			found=results->FindResult((void*)&vy,"vy");
			if(!found)throw ErrorException(__FUNCT__," could not find vy to compute min_vy");

			min_vy=vy[0];
			for(j=1;j<numberofnodes;j++){
				if (vy[j]<min_vy)min_vy=vy[j];
			}
			if(my_rank==0)responses[i]=min_vy;
		}
		else if(strcmp(response_descriptor,"max_vy")==0){
			double* vy=NULL;
			double max_vy=0;
			
			found=results->FindResult((void*)&vy,"vy");
			if(!found)throw ErrorException(__FUNCT__," could not find vy to compute max_vy");

			max_vy=vy[0];
			for(j=1;j<numberofnodes;j++){
				if (vy[j]>max_vy)max_vy=vy[j];
			}
			if(my_rank==0)responses[i]=max_vy;
		}
		else if(strcmp(response_descriptor,"max_abs_vy")==0){
			double* vy=NULL;
			double max_abs_vy=0;
			
			found=results->FindResult((void*)&vy,"vy");
			if(!found)throw ErrorException(__FUNCT__," could not find vy to compute max_abs_vy");

			max_abs_vy=fabs(vy[0]);
			for(j=1;j<numberofnodes;j++){
				if (fabs(vy[j])>max_abs_vy)max_abs_vy=fabs(vy[j]);
			}
			if(my_rank==0)responses[i]=max_abs_vy;
		}
		else if(strcmp(response_descriptor,"min_vz")==0){
			double* vz=NULL;
			double min_vz=0;
			
			found=results->FindResult((void*)&vz,"vz");
			if(!found)throw ErrorException(__FUNCT__," could not find vz to compute min_vz");

			min_vz=vz[0];
			for(j=1;j<numberofnodes;j++){
				if (vz[j]<min_vz)min_vz=vz[j];
			}
			if(my_rank==0)responses[i]=min_vz;
		}
		else if(strcmp(response_descriptor,"max_vz")==0){
			double* vz=NULL;
			double max_vz=0;
			
			found=results->FindResult((void*)&vz,"vz");
			if(!found)throw ErrorException(__FUNCT__," could not find vz to compute max_vz");

			max_vz=vz[0];
			for(j=1;j<numberofnodes;j++){
				if (vz[j]>max_vz)max_vz=vz[j];
			}
			if(my_rank==0)responses[i]=max_vz;
		}
		else if(strcmp(response_descriptor,"max_abs_vz")==0){
			double* vz=NULL;
			double max_abs_vz=0;
			
			found=results->FindResult((void*)&vz,"vz");
			if(!found)throw ErrorException(__FUNCT__," could not find vz to compute max_abs_vz");

			max_abs_vz=fabs(vz[0]);
			for(j=1;j<numberofnodes;j++){
				if (fabs(vz[j])>max_abs_vz)max_abs_vz=fabs(vz[j]);
			}
			if(my_rank==0)responses[i]=max_abs_vz;
		}
		else{
			if(my_rank==0)printf("%s%s%s"," response descriptor : ",response_descriptor," not supported yet!");
			throw ErrorException(__FUNCT__,exprintf("%s%s%s"," response descriptor : ",response_descriptor," not supported yet!"));
		}
	}

}
