/*!\file Spc.h
 * \brief: header file for spc object
 */

#ifndef _SPC_H_
#define _SPC_H_

#include "./Object.h"
#include "../DataSet/DataSet.h"

class Spc: public Object{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/

	public:

		Spc();
		Spc(int sid,int nodeid, int dof,double value);
		~Spc();

		void   Echo();
		void   DeepEcho();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		char*  GetName();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    GetId(); 
		int    MyRank();
		void   DistributeNumDofs(int* numdofspernode,int analysis_type);
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		Object* copy();

};

#endif  /* _SPC_H_ */
