function displaymaterials(md)
%DISPLAYCONTROL - display material parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays material parameters from model md, 
%   only if requested.
%
%   Usage:
%      displaymaterials(md)

disp(sprintf('   Materials:\n'));

fielddisplay(md,'rho_ice','ice density [kg/m^3]');
fielddisplay(md,'rho_water','water density [kg/m^3]');
fielddisplay(md,'rheology_B','flow law parameter [Pa/s^(1/n)]');
fielddisplay(md,'rheology_n','Glen''s flow law exponent');
fielddisplay(md,'rheology_law','law for the temperature dependance of the rheology: NoneEnum, PatersonEnum or Arrhenius');
fielddisplay(md,'heatcapacity','heat capacity [J/kg/K]');
fielddisplay(md,'thermalconductivity','ice thermal conductivity [W/m/K]');
fielddisplay(md,'meltingpoint','melting point of ice at 1atm in K');
fielddisplay(md,'latentheat','latent heat of fusion [J/m^3]');
fielddisplay(md,'beta','rate of change of melting point with pressure [K/Pa]');
fielddisplay(md,'mixed_layer_capacity','mixed layer capacity [W/kg/K]');
fielddisplay(md,'thermal_exchange_velocity','thermal exchange velocity [m/s]');
