#!/bin/sh
#!/bin/bash

#Genetare a pdf with the list of references provided in $CITE

CITE="Brezzi2004"

#First erase files; 
rm -rf references.*

#create Latex file
cat <<END > references.tex
\documentclass[letterpaper]{article}
\usepackage[T1]{fontenc}
\usepackage[english]{babel}
\makeatletter
%\renewcommand\@biblabel[1]{#1.}     % Arabic numbers, no brackets
%\renewcommand\@biblabel[1]{$^{#1}$} % Superscripts
\renewcommand\@biblabel[1]{}
\makeatother
\bibliographystyle{plain}
\begin{document}
\nocite{$CITE}
\bibliography{$ISSM_DIR/../bibtex/references}
\end{document}
END
#Generate pdf
latex references.tex
bibtex references
latex2rtf references.tex

#Remove all but rtf file
rm -rf references.[!rtf]*
rm -rf references.tex
