function md=loadresultsfromdisk(md,filename)
%LOADRESULTSFROMDISK - load results of solution sequence from disk file "filename"            
%
%   Usage:
%      md=loadresultsfromdisk(md,filename);

%check number of inputs/outputs
if ((nargin~=2) | (nargout~=1)),
	help loadresultsfromdisk;
	error('loadresultsfromdisk: error message.');
end

if ~md.qmu_analysis,

	%initialize md.results if not a structure yet
	if ~isstruct(md.results),
		md.results=struct();
	end

	%load results onto model
	structure=parseresultsfromdisk(filename,~md.io_gather);
	md.results.(structure.SolutionType)=structure;

	%recover solution_type from results
	md.solution_type=structure(1).SolutionType;

	%Check result is consistent, only if it exists
	%disp(sprintf('%s\n','checking result consistency'));
	%if ~isresultconsistent(md,structure(1).SolutionType), After many uses, found out its useless.
	%	%it would be very cruel to use an error, it would kill the computed results (although they are not consistent...)
	%	disp('!! results not consistent correct the model !!') 
	%end

%post processes qmu results if necessary
else

	if isscalar(md.solution_type),
		md.solution_type    =EnumToString(md.solution_type);
	end
	md=postqmu(md);
	cd ..

end
