/*! \file CreateLoadsPrognostic.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsPrognostic(Loads** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediaries*/
	int i;
	int element;
	int penpair_ids[2];
	int count=0;

	/*DataSet*/
	Loads*    loads    = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);

	/*Loads only in DG*/
	if (iomodel->prognostic_DG){

		/*Get edges and elements*/
		IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,"edges");
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");

		/*First load data:*/
		for (i=0;i<iomodel->numberofedges;i++){

			/*Get left and right elements*/
			element=(int)iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]

			/*Now, if this element is not in the partition, pass: */
			if(!iomodel->my_elements[element]) continue;

			/* Add load */
			loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,iomodel,PrognosticAnalysisEnum));
		}

		/*Free data: */
		xfree((void**)&iomodel->edges);
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->thickness);

	}

	/*Create Penpair for penalties: */
	IoModelFetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,iomodel_handle,"penalties");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");

	for(i=0;i<iomodel->numpenalties;i++){

		if(iomodel->my_vertices[(int)iomodel->penalties[2*i+0]-1]){

			/*In debugging mode, check that the second node is in the same cpu*/
			_assert_(iomodel->my_vertices[(int)iomodel->penalties[2*i+1]-1]);

			/*Skip if one of the two is not on the bed*/
			if(!iomodel->gridonbed[(int)iomodel->penalties[2*i+0]-1] || !iomodel->gridonbed[(int)iomodel->penalties[2*i+1]-1]) continue;

			/*Get node ids*/
			penpair_ids[0]=iomodel->nodecounter+(int)iomodel->penalties[2*i+0];
			penpair_ids[1]=iomodel->nodecounter+(int)iomodel->penalties[2*i+1];

			/*Create Load*/
			loads->AddObject(new Penpair(
							iomodel->loadcounter+count+1,
							&penpair_ids[0],
							PrognosticAnalysisEnum));
			count++;
		}
	}

	/*free ressources: */
	xfree((void**)&iomodel->penalties);
	xfree((void**)&iomodel->gridonbed);


	/*Assign output pointer: */
	*ploads=loads;
}
