%This test is a test from the ISMP-HOM Intercomparison project
%TestF 
L=100000; %in m
nx=30; %numberof nodes in x direction
ny=30;
md=model;
md=squaremesh(md,L,L,nx,ny);
%md=mesh(md,'../Exp/SquareISMIP.exp',5500);
md=geography(md,'',''); %ice sheet test
md=parameterize(md,'../Par/ISMIPF.par');
md=extrude(md,3,1);

md=setelementstype(md,'pattyn','all');
%md=setelementstype(md,'pattyn','all','stokes','all'); 

md.spcvelocity(:,:)=0;
%Create dirichlet on the bed if no slip
pos=find(md.gridonbed);
md.spcvelocity(pos,1:2)=1;
md.spctemperature(:,2)=255;
md.spctemperature(:,1)=255;

%Create MPCs to have periodic boundary conditions
posx=find(md.x==0);
posx2=find(md.x==max(md.x));

posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

md.penalties=[posx,posx2;posy,posy2];

md.dt=5;
md.ndt=50;

%Compute the diagnostic
md=SetParallel(md,8);
md.verbose=verbose('convergence',true,'solution',true);
md.rheology_B=md.rheology_B/2;  %as mu=B/(2 \epsilon_e) and visco=B in matice for linear case
md=solve(md,'analysis_type',Transient2DSolutionEnum);

%vx=PatchToVec(md.results.DiagnosticSolution.Vx);
%vy=PatchToVec(md.results.DiagnosticSolution.Vy);
%vz=PatchToVec(md.results.DiagnosticSolution.Vz);

plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers)
