/*! \file OptionStruct.h 
 *  \brief: header file for optionsstruct object
 */

#ifndef _OPTIONSSTRUCT_H_
#define _OPTIONSSTRUCT_H_

/*Headers:{{{1*/
#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

#include "./Option.h"
/*}}}*/

class OptionStruct: public Option {

	public:

		Options** values;

		/*OptionStruct constructors, destructors {{{1*/
		OptionStruct();
		~OptionStruct();
		/*}}}*/
		/*Object virtual functions definitions:{{{1*/
		void  Echo();
		void  DeepEcho();
		void  DeepEcho(char* indent);
		int   Id(){_error_("Not implemented yet");};
		int   MyRank(){_error_("Not implemented yet");};
		void  Marshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   MarshallSize(){_error_("Not implemented yet");};
		void  Demarshall(char** pmarshalled_dataset){_error_("Not implemented yet");};
		int   Enum(){return OptionStructEnum;};
		Object* copy(){_error_("Not implemented yet");};
		/*}}}*/

		/*virtual functions: */
		char* Name();
		int   NumEl();
		int   NDims();
		int*  Size();
		void  Get(double* pvalue){_error_("An OptionStruct object cannot return a double");};
		void  Get(bool* pvalue){  _error_("An OptionStruct object cannot return a bool");};
		void  Get(char** pvalue){ _error_("An OptionStruct object cannot return a string");};
		void  Get(double** pvalue,int *pnumel){ _error_("An OptionStruct object cannot return a double vec");};

};
#endif  /* _OPTIONSSTRUCT_H */

