function tolerance=testsgettolerance(md,package,solution,field),
%TESTSGETTOLERANCE - give the tolerance for the nightly run 
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   It gives the accepted tolerance, given the package, the solution and the field check.
%
%   Usage:
%      tolerance=testsgettolerance(md,package,solution,field),
%
%   Example:
%      tolerance=testsgettolerance(md,'cielo','diagnostic','vel'),
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

if (strcmpi(package,'macayeal') | strcmpi(package,'ice') | strcmpi(package,'cielo_serial')),
	tolerance=10^-15;

elseif strcmpi(package,'cielo_parallel'),
	if strcmpi(solution,'prognostic'),
		tolerance=10^-14;

	elseif strcmpi(solution,'diagnostic'),
		if md.isstokes,
			tolerance=10^-4;
		elseif any(md.gridonpattyn),
			tolerance=10^-6;
		else,
			tolerance=10^-13;
		end

	elseif strcmpi(solution,'thermal_steady'),
		if strcmpi(field,'melting'),
			tolerance=10^-1;
		elseif strcmpi(field,'temperature'),
			tolerance=10^-6;
		end

	else
		error(['testsgettolerance error message: solution '  solution ' not supported yet with package cielo_parallel']);
	end

else
	error(['testsgettolerance error message: package '  package ' not supported yet']);
end
