/*\file Test.c
 *\brief:  test module. do whatever you want in here
 */

#include "./Test.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	Options *options = NULL;
	double   test;
	char    *name    = NULL;
	bool     logical;

	printf("Parsing options:\n");
	options=new Options(0,nrhs,prhs);

	options->Get(&test,"test",1.);
	printf("\n value of \"test\" is %g\n",test);

	options->Get(&name,"model.name","default");
	printf("\n value of \"model.name\" is %s\n",name);

	options->Get(&test,"CELL[0,2]",1.);
	printf("\n value of \"CELL[0,2]\" is %g\n",test);

	options->Get(&logical,"logical");
	printf("\n value of \"logical\" is %s\n",logical?"true":"false");

	delete options;
	xfree((void**)&name);
}

void TestUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: %s(whatever in here);\n",__FUNCT__);
	_printf_(true,"\n");
}
