/*!\file OptionChar.cpp
 * \brief: implementation of the optionschar object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionChar::OptionChar(){{{1*/
OptionChar::OptionChar(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionChar::~OptionChar(){{{1*/
OptionChar::~OptionChar(){

	if (values) xfree((void**)&values);

}
/*}}}*/

/*Other*/
/*FUNCTION OptionChar::Echo {{{1*/
void  OptionChar::Echo(){

	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"OptionChar Echo:\n");
	Option::Echo();

	if (values && size) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"        values: \"%s\"\n" ,values[0]);
			_printf_(flag,"        values: \"%s\"\n" ,values);
		}
		else {
			StringFromSize(cstr,size,ndims);
			_printf_(flag,"        values: %s %s\n" ,cstr,"char");
		}
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionChar::DeepEcho() {{{1*/
void  OptionChar::DeepEcho(){

	char  indent[81]="";

	OptionChar::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionChar::DeepEcho(char* indent) {{{1*/
void  OptionChar::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionChar DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values) {
//		if (numel == 1) {
		if (1) {
//			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values[0]);
			_printf_(flag,"%s        values: \"%s\"\n" ,indent,values);
		}
		else {
			dims=(int *) xmalloc(ndims*sizeof(int));
			for (i=0; i<numel; i++) {
				RowWiseDimsFromIndex(dims,i,size,ndims);
				StringFromDims(cstr,dims,ndims);
				_printf_(flag,"%s        values%s: \"%s\"\n" ,indent,cstr,values[i]);
			}
			xfree((void**)&dims);
		}
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionChar::Name {{{1*/
char* OptionChar::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionChar::NumEl {{{1*/
int   OptionChar::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionChar::NDims {{{1*/
int   OptionChar::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionChar::Size {{{1*/
int*  OptionChar::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionChar::Get {{{1*/
//void* OptionChar::Get(){

//	;

//	return;
//}
/*}}}*/
