/*!\file OptionsCell.cpp
 * \brief: implementation of the optionscell object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION OptionsCell::OptionsCell(){{{1*/
OptionsCell::OptionsCell(){

	values    =NULL;

}
/*}}}*/
/*FUNCTION OptionsCell::~OptionsCell(){{{1*/
OptionsCell::~OptionsCell(){

	if (values){
		delete values;
		values    =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION OptionsCell::Echo {{{1*/
void  OptionsCell::Echo(){

	char cstr[81];
	bool flag     = true;

	_printf_(flag,"OptionsCell Echo:\n");
	Option::Echo();

	if (values && size) {
		StringFromSize(cstr,size,ndims);
		_printf_(flag,"        values: %s %s\n" ,cstr,"cell");
	}
	else _printf_(flag,"        values: [empty]\n" );
}
/*}}}*/
/*FUNCTION OptionsCell::DeepEcho() {{{1*/
void  OptionsCell::DeepEcho(){

	char  indent[81]="";

	OptionsCell::DeepEcho(indent);

	return;
}
/*}}}*/
/*FUNCTION OptionsCell::DeepEcho(char* indent) {{{1*/
void  OptionsCell::DeepEcho(char* indent){

	int   i;
	int*  dims;
	char  indent2[81];
	char  cstr[81];
	bool  flag=true;

	_printf_(flag,"%sOptionsCell DeepEcho:\n",indent);
	Option::DeepEcho(indent);

	strcpy(indent2,indent);
	strcat(indent2,"  ");

	if (values->Size()) {
		dims=(int *) xmalloc(ndims*sizeof(int));
		for (i=0; i<values->Size(); i++) {
			ColumnWiseDimsFromIndex(dims,i,size,ndims);
			StringFromDims(cstr,dims,ndims);
			_printf_(flag,"%s        values: %s begin\n" ,indent,cstr);
			((Option *)values->GetObjectByOffset(i))->DeepEcho(indent2);
			_printf_(flag,"%s        values: %s end\n"   ,indent,cstr);
		}
		xfree((void**)&dims);
	}
	else _printf_(flag,"%s        values: [empty]\n" ,indent);
}
/*}}}*/
/*FUNCTION OptionsCell::Name {{{1*/
char* OptionsCell::Name(){

	return(Option::Name());
}
/*}}}*/
/*FUNCTION OptionsCell::NumEl {{{1*/
int   OptionsCell::NumEl(){

	return(Option::NumEl());
}
/*}}}*/
/*FUNCTION OptionsCell::NDims {{{1*/
int   OptionsCell::NDims(){

	return(Option::NDims());
}
/*}}}*/
/*FUNCTION OptionsCell::Size {{{1*/
int*  OptionsCell::Size(){

	return(Option::Size());
}
/*}}}*/
/*FUNCTION OptionsCell::Get {{{1*/
//void* OptionsCell::Get(){

//	;

//	return;
//}
/*}}}*/
